/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.lib.FormatDesc;

public final class LuaDouble
extends LuaNumber {
    public static final LuaDouble NAN = new LuaDouble(Double.NaN);
    public static final LuaDouble POSINF = new LuaDouble(Double.POSITIVE_INFINITY);
    public static final LuaDouble NEGINF = new LuaDouble(Double.NEGATIVE_INFINITY);
    private static final String JSTR_NAN = "nan";
    private static final String JSTR_POSINF = "inf";
    private static final String JSTR_NEGINF = "-inf";
    private static final LuaString STR_NAN = ValueFactory.valueOf("nan");
    private static final LuaString STR_POSINF = ValueFactory.valueOf("inf");
    private static final LuaString STR_NEGINF = ValueFactory.valueOf("-inf");
    private static final FormatDesc NUMBER_FORMAT = FormatDesc.ofUnsafe(".14g");
    private final double v;

    public static LuaNumber valueOf(double d) {
        int id = (int)d;
        return d == (double)id ? LuaInteger.valueOf(id) : new LuaDouble(d);
    }

    private LuaDouble(double d) {
        this.v = d;
    }

    public int hashCode() {
        return Double.hashCode(this.v);
    }

    public double doubleValue() {
        return this.v;
    }

    @Override
    public double toDouble() {
        return this.v;
    }

    @Override
    public int toInteger() {
        return (int)this.v;
    }

    public boolean equals(Object o) {
        return o instanceof LuaDouble && ((LuaDouble)o).v == this.v;
    }

    @Override
    public String toString() {
        if (Double.isNaN(this.v)) {
            return JSTR_NAN;
        }
        if (Double.isInfinite(this.v)) {
            return this.v < 0.0 ? JSTR_NEGINF : JSTR_POSINF;
        }
        Buffer buffer = new Buffer(16);
        NUMBER_FORMAT.format(buffer, this.v);
        return buffer.toString();
    }

    @Override
    public LuaString checkLuaString() {
        if (Double.isNaN(this.v)) {
            return STR_NAN;
        }
        if (Double.isInfinite(this.v)) {
            return this.v < 0.0 ? STR_NEGINF : STR_POSINF;
        }
        Buffer buffer = new Buffer(16);
        NUMBER_FORMAT.format(buffer, this.v);
        return buffer.toLuaString();
    }

    @Override
    public LuaValue toLuaString() {
        return this.checkLuaString();
    }

    @Override
    public int checkInteger() {
        return (int)this.v;
    }

    @Override
    public long checkLong() {
        return (long)this.v;
    }

    @Override
    public double checkDouble() {
        return this.v;
    }

    @Override
    public String checkString() {
        return this.toString();
    }
}

